<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

$conn = new mysqli("localhost", "odmr9632_userdb", "@Sukabumi2018", "odmr9632_order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';
// Tambah Produk Digital
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nama_produk'])) {
  $nama = trim($_POST['nama_produk']);
  if ($nama !== '') {
    $stmt = $conn->prepare("INSERT INTO produk_digital (nama_produk) VALUES (?)");
    $stmt->bind_param("s", $nama);
    if ($stmt->execute()) {
      $msg = '✅ Berhasil menambahkan produk digital!';
    } else {
      $msg = '❌ Gagal menambahkan produk.';
    }
  } else {
    $msg = '❗ Nama produk tidak boleh kosong.';
  }
}

// Hapus Produk
if (isset($_GET['hapus'])) {
  $id = (int) $_GET['hapus'];
  $conn->query("DELETE FROM produk_digital WHERE id=$id");
  header("Location: tambah_produk_digital.php");
  exit;
}

$produk_digital = $conn->query("SELECT * FROM produk_digital ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tambah Produk Digital</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f0f0f0;
      padding: 30px;
    }
    .form-box, .table-box {
      background: white;
      padding: 20px;
      margin: 0 auto 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      max-width: 500px;
    }
    input, button {
      width: 100%;
      padding: 10px;
      margin-top: 10px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      box-sizing: border-box;
    }
    button {
      background: #f44336;
      color: white;
      border: none;
      cursor: pointer;
    }
    button:hover {
      background: #d32f2f;
    }
    .msg {
      margin-top: 15px;
      color: green;
      font-weight: bold;
      text-align: center;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ddd;
      text-align: center;
    }
    th { background: #f44336; color: white; }
    a.edit, a.hapus {
      padding: 4px 8px;
      font-size: 13px;
      border-radius: 4px;
      text-decoration: none;
      color: white;
      margin: 2px;
      display: inline-block;
    }
    a.edit { background: #4CAF50; }
    a.hapus { background: #f44336; }
    .back-link {
      display: block;
      text-align: center;
      margin-top: 20px;
      text-decoration: none;
      color: #f44336;
    }
  </style>
</head>
<body>
  <div class="form-box">
    <h2>💾 Tambah Produk Digital</h2>
    <form method="POST">
      <input type="text" name="nama_produk" placeholder="Nama Produk Digital" required>
      <button type="submit">Tambah</button>
    </form>
    <?php if ($msg): ?><div class="msg"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  </div>

  <div class="table-box">
    <h3>📋 Daftar Produk Digital</h3>
    <table>
      <thead>
        <tr>
          <th>No</th>
          <th>Nama Produk</th>
          <th>Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php $no = 1; while($p = $produk_digital->fetch_assoc()): ?>
        <tr>
          <td><?= $no++ ?></td>
          <td><?= htmlspecialchars($p['nama_produk']) ?></td>
          <td>
            <a href="edit_produk_digital.php?id=<?= $p['id'] ?>" class="edit">Edit</a>
            <a href="?hapus=<?= $p['id'] ?>" class="hapus" onclick="return confirm('Yakin ingin hapus produk ini?')">Hapus</a>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <a href="menu_admin.php" class="back-link">⬅️ Kembali ke Menu Admin</a>
</body>
</html>
