<!DOCTYPE html>
<html>
<head>
  <title>Form Input Order</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://fonts.googleapis.com/css2?family=Inter&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Inter', sans-serif;
      background: #f8f8f8;
      padding: 20px;
    }
    .form-container {
      background: white;
      max-width: 600px;
      margin: auto;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      margin-bottom: 30px;
    }
    label {
      display: block;
      margin-top: 15px;
    }
    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      box-sizing: border-box;
    }
    button {
      background-color: #4CAF50;
      color: white;
      border: none;
      margin-top: 20px;
      cursor: pointer;
      padding: 10px;
      font-size: 16px;
      border-radius: 6px;
      width: 100%;
    }
    button:hover {
      background-color: #45a049;
    }
  </style>
</head>

<body>
  <div class="form-container">
    <h2 style="text-align: center;">Form Input Order</h2>
    <form method="POST" action="simpan.php">
      <label>Tanggal:</label><input type="date" name="tanggal">
      <label>Opsi Produk:</label>
      <select name="opsi_produk" onchange="updateProduk()">
  <option value="Fisik">Fisik</option>
  <option value="Digital">Digital</option>
</select>

      <label>Nama CS:</label>
<?php session_start(); ?>
<input type="text" name="nama_cs" value="<?php echo isset($_SESSION['nama_cs']) ? $_SESSION['nama_cs'] : ''; ?>" readonly>
</select>
      <label>Nama Customer:</label><input type="text" name="nama_customer">
      <label>Nama Produk:</label>
<select name="nama_produk">
  <option>-- Pilih Produk --</option>
</select>

<label>No. WA:</label>
<input type="text" name="no_wa">

<div class="hide-if-digital">
  <label>Provinsi:</label>
  <input type="text" name="provinsi">
</div>

<div class="hide-if-digital">
  <label>Kota:</label>
  <input type="text" name="kota">
</div>

<div class="hide-if-digital">
  <label>Kecamatan:</label>
  <input type="text" name="kecamatan">
</div>

<div class="hide-if-digital">
  <label>Alamat:</label>
  <textarea name="alamat"></textarea>
</div>

<label>Qty:</label>
<input type="number" name="qty">

<label>Harga Jual:</label>
<input type="number" name="harga_jual">

<div class="hide-if-digital">
  <label>Ongkir:</label>
  <input type="number" name="ongkir">
</div>

<div class="hide-if-digital">
  <label>Fee COD:</label>
  <input type="number" name="fee_cod">
</div>

<label>Status Pengiriman:</label>
<select name="status_pengiriman" id="status_pengiriman">
  <option value="COD">COD</option>
  <option value="TF">TF</option>
  <option value="DFOD">DFOD</option>
</select>

<input type="hidden" name="status_pengiriman_hidden">
      <button type="submit">Simpan</button>
	  <a href="menu_cs.php" style="
  display: block;
  text-align: center;
  margin-top: 10px;
  padding: 10px;
  background-color: #2196F3;
  color: white;
  text-decoration: none;
  border-radius: 6px;
  font-size: 16px;
">Kembali ke Menu CS</a>
<a href="index.php" style="
  display: block;
  text-align: center;
  margin-top: 10px;
  padding: 10px;
  background-color: #9e9e9e;
  color: white;
  text-decoration: none;
  border-radius: 6px;
  font-size: 16px;
">Kembali ke Menu Utama</a>
    </form>
  </div>
<script>
function updateProduk() {
  const opsi = document.querySelector('[name="opsi_produk"]').value;
  const fieldsToHide = document.querySelectorAll('.hide-if-digital');
  const statusPengiriman = document.querySelector('[name="status_pengiriman"]');
  const statusHidden = document.querySelector('[name="status_pengiriman_hidden"]');
  const produkDropdown = document.querySelector('[name="nama_produk"]');

  // Mode Digital
  if (opsi === "Digital") {
    fieldsToHide.forEach(el => el.style.display = "none");
    statusPengiriman.value = "TF";
    statusPengiriman.setAttribute("disabled", true);
    statusHidden.value = "TF";
  } 
  // Mode Fisik
  else {
    fieldsToHide.forEach(el => el.style.display = "block");
    statusPengiriman.removeAttribute("disabled");
    statusPengiriman.value = "COD";
    statusHidden.value = "COD";
  }

  // Sinkronisasi value saat user ubah dropdown status (khusus Fisik)
  statusPengiriman.onchange = function () {
    statusHidden.value = this.value;
  };

  // Ambil produk dari PHP sesuai jenis produk
  fetch(`get_produk.php?jenis=${opsi}`)
    .then(res => res.json())
    .then(data => {
      produkDropdown.innerHTML = '<option value="">-- Pilih Produk --</option>';
      data.forEach(item => {
        const opt = document.createElement("option");
        opt.value = item;
        opt.textContent = item;
        produkDropdown.appendChild(opt);
      });
    });
}

// ✅ Pastikan hidden ikut dikirim saat submit (backup jaga-jaga)
document.querySelector('form').addEventListener('submit', function () {
  const statusPengiriman = document.querySelector('[name="status_pengiriman"]');
  const statusHidden = document.querySelector('[name="status_pengiriman_hidden"]');
  statusHidden.value = statusPengiriman.value;
});


document.addEventListener("DOMContentLoaded", updateProduk);
</script>

</body>
</html>
