<?php
session_start();
if (!isset($_SESSION['warehouse'])) {
  header("Location: login_warehouse.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama = $_POST['nama_barang'];
  $jumlah = (int) $_POST['jumlah'];
  $keterangan = $_POST['keterangan'];

  $stmt = $conn->prepare("INSERT INTO barang_hilang (nama_barang, jumlah, keterangan) VALUES (?, ?, ?)");
  $stmt->bind_param("sis", $nama, $jumlah, $keterangan);

  if ($stmt->execute()) {
    $msg = "✅ Data berhasil dicatat.";
  } else {
    $msg = "❌ Gagal mencatat barang hilang.";
  }
}

$barang_list = $conn->query("SELECT nama_produk FROM produk_fisik ORDER BY nama_produk ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Catat Barang Hilang</title>
  <style>
    body { font-family: Arial; background: #f5f5f5; padding: 20px; }
    .container { background: white; max-width: 500px; margin: auto; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #d84315; }
    label { display: block; margin-top: 15px; }
    input, select, textarea { width: 100%; padding: 8px; border-radius: 5px; border: 1px solid #ccc; }
    button { background: #f44336; color: white; border: none; padding: 10px 15px; margin-top: 20px; border-radius: 5px; cursor: pointer; width: 100%; }
    .msg { text-align: center; margin-top: 20px; font-weight: bold; }
    a { display: block; text-align: center; margin-top: 20px; color: #f44336; text-decoration: none; }
  </style>
</head>
<body>
<div class="container">
  <h2>📉 Catat Barang Hilang</h2>
  <form method="post">
    <label>Nama Barang</label>
    <select name="nama_barang" required>
      <option value="">-- Pilih Barang --</option>
      <?php while ($row = $barang_list->fetch_assoc()): ?>
        <option value="<?= htmlspecialchars($row['nama_produk']) ?>"><?= htmlspecialchars($row['nama_produk']) ?></option>
      <?php endwhile; ?>
    </select>

    <label>Jumlah</label>
    <input type="number" name="jumlah" min="1" required>

    <label>Keterangan</label>
    <textarea name="keterangan" rows="4" placeholder="Contoh: Hilang saat pengiriman..." required></textarea>

    <button type="submit">💾 Simpan Catatan</button>
  </form>
  <?php if ($msg): ?><p class="msg"><?= $msg ?></p><?php endif; ?>
  <a href="dashboard_warehouse.php">⬅️ Kembali ke Dashboard</a>
</div>
</body>
</html>
