<?php
session_start();
if (!isset($_SESSION['warehouse'])) {
  header("Location: login_warehouse.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama_produk = $_POST['nama_produk'];
  $qty = (int) $_POST['qty'];
  $keterangan = $_POST['keterangan'];

  // Catat ke riwayat
  $stmt = $conn->prepare("INSERT INTO riwayat_stok (nama_produk, jenis, qty, keterangan, tanggal) VALUES (?, 'keluar', ?, ?, NOW())");
  if ($stmt) {
    $stmt->bind_param("sis", $nama_produk, $qty, $keterangan);
    $stmt->execute();
  } else {
    die("❌ Query gagal: " . $conn->error);
  }

  // Update ke stok
  $stmt2 = $conn->prepare("UPDATE produk_fisik SET stok_keluar = stok_keluar + ?, stok = stok - ? WHERE nama_produk = ?");
  if ($stmt2) {
    $stmt2->bind_param("iis", $qty, $qty, $nama_produk);
    $stmt2->execute();
    $msg = "✅ Stok berhasil dikurangi!";
  } else {
    die("❌ Update gagal: " . $conn->error);
  }
}

// Ambil daftar produk
$produk_list = $conn->query("SELECT nama_produk FROM produk_fisik");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Kurangi Stok</title>
  <style>
    body { font-family: Arial; background: #f0f0f0; padding: 20px; }
    .box { max-width: 500px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #e53935; }
    label { display: block; margin-top: 15px; }
    input, select, textarea {
      width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px;
    }
    .btn { margin-top: 20px; background: #e53935; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
    .msg { margin-top: 15px; text-align: center; color: green; }
  </style>
</head>
<body>
<div class="box">
  <h2>➖ Kurangi Stok</h2>
  <?php if ($msg): ?><div class="msg"><?= $msg ?></div><?php endif; ?>
  <form method="post">
    <label>Nama Produk</label>
    <select name="nama_produk" required>
      <option value="">-- Pilih Produk --</option>
      <?php while ($row = $produk_list->fetch_assoc()): ?>
        <option value="<?= $row['nama_produk'] ?>"><?= $row['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>

    <label>Jumlah Keluar</label>
    <input type="number" name="qty" required min="1">

    <label>Keterangan</label>
    <select name="keterangan">
      <option value="Terjual">Terjual</option>
      <option value="Rusak">Rusak</option>
      <option value="Hilang">Hilang</option>
    </select>

    <button type="submit" class="btn">Simpan Pengurangan</button>
  </form>
  <div style="text-align:center; margin-top:20px;">
    <a href="dashboard_warehouse.php">⬅️ Kembali ke Dashboard</a>
  </div>
</div>
</body>
</html>
