<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$tgl1 = $_GET['tgl1'] ?? '';
$tgl2 = $_GET['tgl2'] ?? '';
$produk_filter = $_GET['produk'] ?? [];

$where = "WHERE 1=1";
if ($tgl1 && $tgl2) $where .= " AND tanggal BETWEEN '$tgl1' AND '$tgl2'";

$produk_checked = [];
$produk_all = [];
$produk_query = $conn->query("SELECT DISTINCT nama_produk FROM orders");
while ($p = $produk_query->fetch_assoc()) {
  $produk_all[] = $p['nama_produk'];
  if (in_array($p['nama_produk'], $produk_filter)) {
    $produk_checked[] = "'" . $conn->real_escape_string($p['nama_produk']) . "'";
  }
}

if ($produk_checked) {
  $where .= " AND nama_produk IN (" . implode(",", $produk_checked) . ")";
}

$query = "SELECT nama_produk, SUM(harga_jual) as total_pendapatan FROM orders $where GROUP BY nama_produk";
$data_produk = $conn->query($query);

$total_omset = 0;
$pendapatan_lain = 0;
$hpp_total = 0;
$total_biaya_iklan = 0;
$total_ppn = 0;
$denda_return = 0;
$unprofit = 0;

$produk_hpp = [];
$hpp_q = $conn->query("SELECT * FROM produk_fisik");
while ($row = $hpp_q->fetch_assoc()) {
  $produk_hpp[$row['nama_produk']] = (int)$row['hpp'];
}

$orders = $conn->query("SELECT * FROM orders $where");
while ($row = $orders->fetch_assoc()) {
  $total_omset += (int)$row['harga_jual'];
  $total_biaya_iklan += (int)$row['biaya_iklan'];
  $total_ppn += (int)$row['ppn'];

  $produk = $row['nama_produk'];
  $qty = $row['qty'] ?? 1;
  $hpp = $produk_hpp[$produk] ?? 0;
  $hpp_total += ($hpp * $qty);

  if ($row['status_pengiriman'] === 'Return') {
    $denda_return += (int)$row['ongkir'] / 2;
    $unprofit += ($row['harga_jual'] - $hpp);
  }
}

$laba_kotor = $total_omset - $hpp_total;
$total_operasional = $total_biaya_iklan + $total_ppn + $denda_return + $unprofit;
$laba_bersih = $laba_kotor - $total_operasional;
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Laporan Laba Rugi</title>
  <style>
    body { font-family: Arial; background: #f4f4f4; padding: 20px; }
    .container { background: white; max-width: 900px; margin: auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #e53935; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: right; }
    th { background: #e53935; color: white; text-align: left; }
    .footer { text-align: center; margin-top: 30px; }
    .btn { padding: 10px 20px; background: #4caf50; color: white; text-decoration: none; border-radius: 5px; }
    .checkboxes { margin: 10px 0; }
    .checkboxes label { display: inline-block; margin-right: 10px; }
  </style>
</head>
<body>
<div class="container">
  <h2>📊 Laporan Laba Rugi</h2>

  <form method="get" style="text-align: center;">
    <label>Tanggal:</label>
    <input type="date" name="tgl1" value="<?= $tgl1 ?>"> -
    <input type="date" name="tgl2" value="<?= $tgl2 ?>">
    <div class="checkboxes">
      <?php foreach ($produk_all as $produk): ?>
        <label>
          <input type="checkbox" name="produk[]" value="<?= htmlspecialchars($produk) ?>" <?= in_array($produk, $produk_filter) ? 'checked' : '' ?>>
          <?= htmlspecialchars($produk) ?>
        </label>
      <?php endforeach; ?>
    </div>
    <button type="submit">Filter</button>
  </form>

  <h3>Pendapatan Usaha</h3>
  <table>
    <tr><th>Nama Produk</th><th>Jumlah</th></tr>
    <?php while ($p = $data_produk->fetch_assoc()): ?>
    <tr>
      <td style="text-align:left;">📦 <?= $p['nama_produk'] ?></td>
      <td>Rp<?= number_format($p['total_pendapatan']) ?></td>
    </tr>
    <?php endwhile; ?>
    <tr><td><strong>Pendapatan Lain (Cashback)</strong></td><td>Rp0</td></tr>
    <tr><th>Total Pendapatan Usaha</th><th>Rp<?= number_format($total_omset) ?></th></tr>
  </table>

  <h3>Beban Pokok Pendapatan</h3>
  <table>
    <tr><td style="text-align:left;">HPP</td><td>Rp<?= number_format($hpp_total) ?></td></tr>
    <tr><th>Laba Kotor</th><th>Rp<?= number_format($laba_kotor) ?></th></tr>
  </table>

  <h3>Beban Administrasi & Operasional</h3>
  <table>
    <tr><td style="text-align:left;">Promosi Iklan & PPN</td><td>Rp<?= number_format($total_biaya_iklan + $total_ppn) ?></td></tr>
    <tr><td style="text-align:left;">Un Profit (Return)</td><td>Rp<?= number_format($unprofit) ?></td></tr>
    <tr><td style="text-align:left;">Denda Return</td><td>Rp<?= number_format($denda_return) ?></td></tr>
    <tr><th>Total Beban Operasional</th><th>Rp<?= number_format($total_operasional) ?></th></tr>
  </table>

  <h3>Laba Bersih</h3>
  <table>
    <tr><th colspan="2" style="text-align:right; font-size: 18px;">Rp<?= number_format($laba_bersih) ?></th></tr>
  </table>

  <div class="footer">
    <form action="export_laba_rugi_excel.php" method="GET">
  <input type="hidden" name="tgl1" value="<?= $tgl1 ?>">
  <input type="hidden" name="tgl2" value="<?= $tgl2 ?>">
  <?php foreach ($produk_filter as $produk): ?>
    <input type="hidden" name="produk[]" value="<?= htmlspecialchars($produk) ?>">
  <?php endforeach; ?>
  <button type="submit" class="btn">📥 Download Excel</button>
</form>

    <br><br>
    <a href="menu_admin.php" class="btn" style="background:#9e9e9e;">⬅️ Kembali</a>
  </div>
</div>
</body>
</html>