<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$filter_cs = $_GET['cs'] ?? '';
$filter_produk = $_GET['produk'] ?? '';
$tgl1 = $_GET['tgl1'] ?? '';
$tgl2 = $_GET['tgl2'] ?? '';

$where = "WHERE 1=1";
if ($filter_cs) $where .= " AND nama_cs='$filter_cs'";
if ($filter_produk) $where .= " AND nama_produk='$filter_produk'";
if ($tgl1 && $tgl2) $where .= " AND tanggal BETWEEN '$tgl1' AND '$tgl2'";

$result = $conn->query("SELECT * FROM orders $where ORDER BY tanggal DESC");
$cs_list = $conn->query("SELECT nama_cs FROM cs");
$produk_list = $conn->query("
  SELECT nama_produk FROM produk_fisik
  UNION
  SELECT nama_produk FROM produk_digital
");

$omset = 0;
$ongkir = 0;
$fee_cod = 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Semua Order</title>
  <style>
    body { font-family: Arial; background: #f5f5f5; padding: 20px; }
    h2 { text-align: center; color: #f44336; }
    form { text-align: center; margin-bottom: 20px; }
    select, input[type=date] {
      padding: 8px; margin: 5px; border-radius: 6px; border: 1px solid #ccc;
    }
    button {
      padding: 8px 16px; border-radius: 6px; border: none;
      background: #4CAF50; color: white; cursor: pointer;
    }
    .summary-container {
      display: flex;
      justify-content: space-around;
      background: #fff;
      padding: 15px;
      border-radius: 10px;
      margin-top: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      font-weight: bold;
      font-size: 16px;
    }
    table {
      width: 100%; border-collapse: collapse; background: white; margin-top: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }
    th, td {
      padding: 10px; border: 1px solid #ddd; text-align: center; font-size: 14px;
    }
    th { background-color: #f44336; color: white; }
    .aksi-btn { padding: 5px 10px; font-size: 12px; border-radius: 4px; text-decoration: none; margin: 2px; display: inline-block; }
    .edit { background: #4CAF50; color: white; }
    .hapus { background: #f44336; color: white; }
    .back-btn {
      display: block; width: 200px; margin: 30px auto; padding: 10px; text-align: center;
      background: gray; color: white; border-radius: 6px; text-decoration: none;
    }
  </style>
</head>
<body>
  <h2>📋 Semua Order</h2>

  <form method="GET">
    <select name="cs">
      <option value="">-- Semua CS --</option>
      <?php while($cs = $cs_list->fetch_assoc()): ?>
        <option value="<?= $cs['nama_cs'] ?>" <?= $filter_cs == $cs['nama_cs'] ? 'selected' : '' ?>><?= $cs['nama_cs'] ?></option>
      <?php endwhile; ?>
    </select>
    <select name="produk">
      <option value="">-- Semua Produk --</option>
      <?php while($pr = $produk_list->fetch_assoc()): ?>
        <option value="<?= $pr['nama_produk'] ?>" <?= $filter_produk == $pr['nama_produk'] ? 'selected' : '' ?>><?= $pr['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>
    <input type="date" name="tgl1" value="<?= $tgl1 ?>">
    <input type="date" name="tgl2" value="<?= $tgl2 ?>">
    <button type="submit">🔍 Filter</button>
  </form>

<?php
$rows = [];
if ($result->num_rows > 0) {
  while ($row = $result->fetch_assoc()) {
    $rows[] = $row;
    $omset += (int)$row['harga_jual'];
    $ongkir += (int)$row['ongkir'];
    $fee_cod += (int)$row['fee_cod'];
  }
}
?>

  <div class="summary-container">
    <div>💰 Omset: Rp<?= number_format($omset) ?></div>
    <div>📦 Ongkir: Rp<?= number_format($ongkir) ?></div>
    <div>💸 Fee COD: Rp<?= number_format($fee_cod) ?></div>
  </div>

  <form method="POST" action="export_excel.php">
  <button type="submit" style="margin: 20px 0;">⬇️ Download yang Dipilih</button>
  <table>
    <thead>
      <tr>
        <th><input type="checkbox" id="checkAll"></th>
        <th>No</th>
        <th>Tanggal</th>
        <th>Produk</th>
        <th>CS</th>
        <th>Customer</th>
        <th>Qty</th>
        <th>Harga</th>
        <th>Fee COD</th>
        <th>Ongkir</th>
        <th>Provinsi</th>
        <th>Kota</th>
        <th>Kecamatan</th>
        <th>Alamat</th>
        <th>Status Pengiriman</th>
        <th>No Resi</th>
        <th>Status Paket</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php if (count($rows) > 0): $no = 1; foreach ($rows as $r): ?>
        <tr>
          <td><input type="checkbox" name="order_ids[]" value="<?= $r['id'] ?>"></td>
          <td><?= $no++ ?></td>
          <td><?= $r['tanggal'] ?></td>
          <td><?= $r['nama_produk'] ?></td>
          <td><?= $r['nama_cs'] ?></td>
          <td><?= $r['nama_customer'] ?></td>
          <td><?= $r['qty'] ?></td>
          <td><?= number_format($r['harga_jual']) ?></td>
          <td><?= number_format($r['fee_cod']) ?></td>
          <td><?= number_format($r['ongkir']) ?></td>
          <td><?= $r['provinsi'] ?></td>
          <td><?= $r['kota'] ?></td>
          <td><?= $r['kecamatan'] ?></td>
          <td><?= $r['alamat'] ?></td>
          <td><?= $r['status_pengiriman'] ?></td>
          <td><?= $r['no_resi'] ?></td>
          <td><?= $r['status_paket'] ?></td>
          <td>
            <a class="aksi-btn edit" href="edit_form_admin.php?id=<?= $r['id'] ?>">Edit</a>
            <a class="aksi-btn hapus" href="hapus_order.php?id=<?= $r['id'] ?>" onclick="return confirm('Yakin ingin hapus?')">Hapus</a>
          </td>
        </tr>
      <?php endforeach; else: ?>
        <tr><td colspan="18">Tidak ada data</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
  </form>

  <a href="menu_admin.php" class="back-btn">⬅️ Kembali ke Menu Admin</a>

  <script>
    document.getElementById('checkAll').addEventListener('click', function () {
      const checkboxes = document.querySelectorAll('input[name="order_ids[]"]');
      checkboxes.forEach(cb => cb.checked = this.checked);
    });
  </script>
</body>
</html>
