<?php include 'koneksi.php'; ?>
<?php
session_start();
if (!isset($_SESSION['nama_cs'])) {
  header("Location: login_cs.php");
  exit;
}

if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$nama_cs = $_SESSION['nama_cs'];
$tgl1 = $_GET['tgl1'] ?? '';
$tgl2 = $_GET['tgl2'] ?? '';

$where = "WHERE nama_cs = '" . $conn->real_escape_string($nama_cs) . "'";
if ($tgl1 && $tgl2) {
  $where .= " AND tanggal BETWEEN '$tgl1' AND '$tgl2'";
}

$profit_setting = $conn->query("SELECT * FROM cs_profit_setting WHERE nama_cs = '$nama_cs'")->fetch_assoc();
$persen_cs = (int)($profit_setting['persen_cs'] ?? 50);

$produk_hpp = [];
$hpp_query = $conn->query("SELECT nama_produk, hpp FROM produk_fisik");
while ($row = $hpp_query->fetch_assoc()) {
  $produk_hpp[$row['nama_produk']] = (int)$row['hpp'];
}

$orders = $conn->query("SELECT nama_produk, harga_jual, ppn, biaya_iklan FROM orders $where");
$profits = [];
$ads_ppn = [];

while ($row = $orders->fetch_assoc()) {
  $produk = $row['nama_produk'];
  $harga_jual = (int)$row['harga_jual'];
  $ppn = (int)$row['ppn'];
  $biaya_iklan = (int)$row['biaya_iklan'];
  $hpp = $produk_hpp[$produk] ?? 0;

  $profit_kotor = $harga_jual - $hpp - $ppn;

  if (!isset($profits[$produk])) {
    $profits[$produk] = 0;
    $ads_ppn[$produk] = ['iklan' => 0, 'ppn' => 0];
  }
  $profits[$produk] += $profit_kotor;
  $ads_ppn[$produk]['iklan'] += $biaya_iklan;
  $ads_ppn[$produk]['ppn'] += $ppn;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Profit Saya</title>
  <style>
    body { font-family: Arial; background: #f9f9f9; padding: 20px; }
    .box { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px #ccc; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
    th { background: #3f51b5; color: white; }
    .btn { background: gray; padding: 8px 16px; color: white; text-decoration: none; border-radius: 5px; }
  </style>
</head>
<body>
<div class="box">
  <h2>📊 Laporan Profit - <?= htmlspecialchars($nama_cs) ?></h2>

  <form method="get" style="text-align:center;">
    <label>Tanggal:</label>
    <input type="date" name="tgl1" value="<?= $tgl1 ?>"> -
    <input type="date" name="tgl2" value="<?= $tgl2 ?>">
    <button type="submit">Filter</button>
  </form>

  <table>
    <tr><th>Produk</th><th>Profit Kotor</th><th>Biaya Iklan</th><th>PPN</th><th>Profit Saya (<?= $persen_cs ?>%)</th></tr>
    <?php if (count($profits) > 0): ?>
      <?php foreach ($profits as $produk => $kotor): ?>
        <tr>
          <td><?= htmlspecialchars($produk) ?></td>
          <td>Rp<?= number_format($kotor) ?></td>
          <td>Rp<?= number_format($ads_ppn[$produk]['iklan']) ?></td>
          <td>Rp<?= number_format($ads_ppn[$produk]['ppn']) ?></td>
          <td>Rp<?= number_format($kotor * $persen_cs / 100) ?></td>
        </tr>
      <?php endforeach; ?>
    <?php else: ?>
      <tr><td colspan="5">Tidak ada data.</td></tr>
    <?php endif; ?>
  </table>

 
  <div style="text-align:center; margin-top:20px;">
    <a href="menu_cs.php" class="btn">⬅️ Kembali ke Menu CS</a>
  </div>
</div>
</body>
</html>
