<?php include 'koneksi.php'; ?>
<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

if (!isset($_GET['id'])) {
  header("Location: tambah_produk_digital.php");
  exit;
}

$id = (int) $_GET['id'];
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nama_produk'])) {
  $nama = trim($_POST['nama_produk']);
  if ($nama !== '') {
    $stmt = $conn->prepare("UPDATE produk_digital SET nama_produk=? WHERE id=?");
    $stmt->bind_param("si", $nama, $id);
    if ($stmt->execute()) {
      $msg = '✅ Berhasil mengupdate produk digital!';
    } else {
      $msg = '❌ Gagal mengupdate produk.';
    }
  } else {
    $msg = '❗ Nama produk tidak boleh kosong.';
  }
}

$result = $conn->query("SELECT * FROM produk_digital WHERE id=$id");
$produk = $result->fetch_assoc();
if (!$produk) {
  header("Location: tambah_produk_digital.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Produk Digital</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f0f0f0;
      padding: 30px;
    }
    .form-box {
      background: white;
      padding: 20px;
      margin: 0 auto;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      max-width: 500px;
    }
    input, button {
      width: 100%;
      padding: 10px;
      margin-top: 10px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      box-sizing: border-box;
    }
    button {
      background: #4CAF50;
      color: white;
      border: none;
      cursor: pointer;
    }
    button:hover {
      background: #388E3C;
    }
    .msg {
      margin-top: 15px;
      color: green;
      font-weight: bold;
      text-align: center;
    }
    .back-link {
      display: block;
      text-align: center;
      margin-top: 20px;
      text-decoration: none;
      color: #f44336;
    }
  </style>
</head>
<body>
  <div class="form-box">
    <h2>✏️ Edit Produk Digital</h2>
    <form method="POST">
      <input type="text" name="nama_produk" value="<?= htmlspecialchars($produk['nama_produk']) ?>" required>
      <button type="submit">Simpan Perubahan</button>
    </form>
    <?php if ($msg): ?><div class="msg"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
    <a href="tambah_produk_digital.php" class="back-link">⬅️ Kembali</a>
  </div>
</body>
</html>
